﻿//***************************************************************************************
// AnimationHelper.h Frank Luna (C) 2011 Wszelkie prawa zastrzeżone.
//
// Contains classes for defining keyframes and animation.
//***************************************************************************************

#ifndef ANIMATION_HELPER_H
#define ANIMATION_HELPER_H

#include "d3dUtil.h"

///<summary>
/// Keyframe określa przekształcenie kości w danym momencie.
///</summary>
struct Keyframe
{
	Keyframe();
	~Keyframe();

    float TimePos;
	XMFLOAT3 Translation;
	XMFLOAT3 Scale;
	XMFLOAT4 RotationQuat;
};

///<summary>
/// BoneAnimation określa lista klatek kluczowych. W przypadku wartości
/// czasu pomiędzy dwiema klatkami kluczowymi dokonujemy interpolacji
/// między nimi.
///
/// Zakładamy, że animacja zawsze posiada przynajmniej dwie klatki kluczowe.
///</summary>
struct BoneAnimation
{
	float GetStartTime()const;
	float GetEndTime()const;

    void Interpolate(float t, XMFLOAT4X4& M)const;

	std::vector<Keyframe> Keyframes; 	

};

#endif // ANIMATION_HELPER_H